/*
 * Decompiled with CFR 0.152.
 */
package javaprinter.logo;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.BitSet;

public class LogoPrinter {
    private final byte[] INITIALIZE_PRINTER = new byte[]{27, 64};
    private final byte[] PRINT_AND_FEED_PAPER = new byte[]{10};
    private final byte[] SELECT_BIT_IMAGE_MODE = new byte[]{27, 42};
    private final byte[] SET_LINE_SPACING = new byte[]{27, 51};
    public int maxBitsWidth = 255;

    private byte[] buildPOSCommand(byte[] command, byte ... args) {
        byte[] posCommand = new byte[command.length + args.length];
        System.arraycopy(command, 0, posCommand, 0, command.length);
        System.arraycopy(args, 0, posCommand, command.length, args.length);
        return posCommand;
    }

    private BitSet getBitsImageData(BufferedImage image) {
        int threshold = 127;
        int index = 0;
        int dimenssions = image.getWidth() * image.getHeight();
        BitSet imageBitsData = new BitSet(dimenssions);
        int y = 0;
        while (y < image.getHeight()) {
            int x = 0;
            while (x < image.getWidth()) {
                int blue;
                int green;
                int color = image.getRGB(x, y);
                int red = (color & 0xFF0000) >> 16;
                int luminance = (int)((double)red * 0.3 + (double)(green = (color & 0xFF00) >> 8) * 0.59 + (double)(blue = color & 0xFF) * 0.11);
                imageBitsData.set(index, luminance < threshold);
                ++index;
                ++x;
            }
            ++y;
        }
        return imageBitsData;
    }

    private static byte[] MergeArrays(byte[] ... arrays) {
        int arrCount = 0;
        int count = 0;
        byte[][] byArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] array = byArray[n2];
            ++arrCount;
            count += array.length;
            ++n2;
        }
        byte[] mergedArray = new byte[count];
        int start = 0;
        byte[][] byArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            byte[] array = byArray2[n4];
            System.arraycopy(array, 0, mergedArray, start, array.length);
            start += array.length;
            ++n4;
        }
        return mergedArray;
    }

    private BufferedImage scale(BufferedImage before, double scale) {
        int w = before.getWidth();
        int h = before.getHeight();
        BufferedImage after = new BufferedImage(w, h, 2);
        AffineTransform at = new AffineTransform();
        at.scale(scale, scale);
        AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
        after = scaleOp.filter(before, after);
        return after;
    }

    private BufferedImage scale2(BufferedImage before, double scale) {
        int origWidth = before.getWidth();
        int newWidth = (int)((double)origWidth * scale);
        int newHeight = (int)((double)before.getHeight() * scale);
        BufferedImage newImage = new BufferedImage(newWidth, newHeight, 1);
        Graphics2D g = newImage.createGraphics();
        g.drawImage(before, 0, 0, newWidth, newHeight, null);
        g.dispose();
        return newImage;
    }

    public byte[] getImageAsBytes(BufferedImage inputImg, double scale, int printersize) {
        int origWidth = inputImg.getWidth();
        scale = 12.0 * (double)printersize / (double)origWidth * scale;
        BufferedImage image = this.scale2(inputImg, scale);
        System.out.println("Scaled from " + origWidth + " to width: " + image.getWidth() + " by scale " + scale);
        try {
            BitSet imageBits = this.getBitsImageData(image);
            byte widthLSB = (byte)(image.getWidth() & 0xFF);
            byte widthMSB = (byte)(image.getWidth() >> 8 & 0xFF);
            byte[] selectBitImageModeCommand = this.buildPOSCommand(this.SELECT_BIT_IMAGE_MODE, 33, widthLSB, widthMSB);
            byte[] setLineSpacing24Dots = this.buildPOSCommand(this.SET_LINE_SPACING, 24);
            byte[] setLineSpacingDefault = new byte[]{27, 50};
            byte[] printOutput = LogoPrinter.MergeArrays(this.INITIALIZE_PRINTER, setLineSpacing24Dots);
            int offset = 0;
            while (offset < image.getHeight()) {
                printOutput = LogoPrinter.MergeArrays(printOutput, selectBitImageModeCommand);
                int imageDataLineIndex = 0;
                byte[] imageDataLine = new byte[3 * image.getWidth()];
                int x = 0;
                while (x < image.getWidth()) {
                    int k = 0;
                    while (k < 3) {
                        byte slice = 0;
                        int b = 0;
                        while (b < 8) {
                            int y = (offset / 8 + k) * 8 + b;
                            int i = y * image.getWidth() + x;
                            boolean v = false;
                            if (i < imageBits.length()) {
                                v = imageBits.get(i);
                            }
                            slice = (byte)(slice | (byte)((v ? 1 : 0) << 7 - b));
                            ++b;
                        }
                        imageDataLine[imageDataLineIndex + k] = slice;
                        ++k;
                    }
                    imageDataLineIndex += 3;
                    ++x;
                }
                offset += 24;
                printOutput = LogoPrinter.MergeArrays(printOutput, imageDataLine, this.PRINT_AND_FEED_PAPER);
            }
            printOutput = LogoPrinter.MergeArrays(printOutput, setLineSpacingDefault);
            return printOutput;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

