/*
 * Decompiled with CFR 0.152.
 */
package javaprinter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import javaprinter.EscPos;
import javaprinter.ReceiptUsbDevice;
import javaprinter.WebReader;
import javaprinter.customreceipt.CustomReceipt;
import javaprinter.json.Config;
import javaprinter.json.closing.Closing;
import javaprinter.json.receipt.Bill;
import javaprinter.json.receipt.ReceiptJob;
import javaprinter.json.work.CancelWorkJob;
import javaprinter.json.work.WorkJob;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import javax.usb.UsbNotActiveException;

public class ReceiptWorker {
    public static void fetchAndPrintPickupJobs(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextPickupPrintJobs&printer=1&fl=" + fl + "&instance=" + config.instance;
        ReceiptWorker.fetchAndPrintPickupJobs(config, "Abholung", url, asyncUsb, allowBigPackets);
    }

    public static void fetchAndPrintFoodWorkJobs1(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextFoodWorkPrintJobs&printer=1&fl=" + fl + "&instance=" + config.instance;
        ReceiptWorker.fetchAndPrintWorkJobs(config, "Speisen", url, asyncUsb, allowBigPackets);
    }

    public static void fetchAndPrintFoodWorkJobs2(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextFoodWorkPrintJobs&printer=2&fl=" + fl + "&instance=" + config.instance;
        ReceiptWorker.fetchAndPrintWorkJobs(config, "Speisen", url, asyncUsb, allowBigPackets);
    }

    public static void fetchAndPrintFoodWorkJobs3(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextFoodWorkPrintJobs&printer=3&fl=" + fl + "&instance=" + config.instance;
        ReceiptWorker.fetchAndPrintWorkJobs(config, "Speisen", url, asyncUsb, allowBigPackets);
    }

    public static void fetchAndPrintFoodWorkJobs4(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextFoodWorkPrintJobs&printer=4&fl=" + fl + "&instance=" + config.instance;
        ReceiptWorker.fetchAndPrintWorkJobs(config, "Speisen", url, asyncUsb, allowBigPackets);
    }

    public static void fetchAndPrintDrinkWorkJobs1(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextDrinkWorkPrintJobs&printer=1&fl=" + fl + "&instance=" + config.instance;
        ReceiptWorker.fetchAndPrintWorkJobs(config, "Getr\u00e4nke", url, asyncUsb, allowBigPackets);
    }

    public static void fetchAndPrintDrinkWorkJobs2(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextDrinkWorkPrintJobs&printer=2&fl=" + fl + "&instance=" + config.instance;
        ReceiptWorker.fetchAndPrintWorkJobs(config, "Getr\u00e4nke", url, asyncUsb, allowBigPackets);
    }

    public static void fetchAndPrintDrinkWorkJobs3(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextDrinkWorkPrintJobs&printer=3&fl=" + fl + "&instance=" + config.instance;
        ReceiptWorker.fetchAndPrintWorkJobs(config, "Getr\u00e4nke", url, asyncUsb, allowBigPackets);
    }

    public static void fetchAndPrintDrinkWorkJobs4(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextDrinkWorkPrintJobs&printer=4&fl=" + fl + "&instance=" + config.instance;
        ReceiptWorker.fetchAndPrintWorkJobs(config, "Getr\u00e4nke", url, asyncUsb, allowBigPackets);
    }

    private static void fetchAndPrintPickupJobs(Config config, String headline, String url, boolean asyncUsb, boolean allowBigPackets) {
        String jobs = WebReader.readUrl(url, config.baseusername, config.basepass, config.printcode, null);
        if (jobs == null) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        ReceiptUsbDevice receiptUsbDevice = new ReceiptUsbDevice();
        try {
            List jobReceipts = (List)mapper.readValue(jobs, (TypeReference)new TypeReference<List<WorkJob>>(){});
            for (WorkJob job : jobReceipts) {
                ReceiptWorker.printWorkReceipt(config, receiptUsbDevice, job, headline, asyncUsb, allowBigPackets);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void fetchAndPrintWorkJobs(Config config, String headline, String url, boolean asyncUsb, boolean allowBigPackets) {
        String jobs = WebReader.readUrl(url, config.baseusername, config.basepass, config.printcode, null);
        if (jobs == null) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        ReceiptUsbDevice receiptUsbDevice = new ReceiptUsbDevice();
        try {
            List jobReceipts = (List)mapper.readValue(jobs, (TypeReference)new TypeReference<List<WorkJob>>(){});
            for (WorkJob job : jobReceipts) {
                ReceiptWorker.printWorkReceipt(config, receiptUsbDevice, job, headline, asyncUsb, allowBigPackets);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void fetchAndPrintCancelFoodWorkJobs1(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextCancelFoodWorkPrintJobs&printer=1&fl=" + fl + "&instance=" + config.instance;
        ReceiptWorker.fetchAndPrintCancelWorkJobs(config, "Storno Speise", url, asyncUsb, allowBigPackets);
    }

    public static void fetchAndPrintCancelFoodWorkJobs2(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextCancelFoodWorkPrintJobs&printer=2&fl=" + fl + "&instance=" + config.instance;
        ReceiptWorker.fetchAndPrintCancelWorkJobs(config, "Storno Speise", url, asyncUsb, allowBigPackets);
    }

    public static void fetchAndPrintCancelFoodWorkJobs3(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextCancelFoodWorkPrintJobs&printer=3&fl=" + fl + "&instance=" + config.instance;
        ReceiptWorker.fetchAndPrintCancelWorkJobs(config, "Storno Speise", url, asyncUsb, allowBigPackets);
    }

    public static void fetchAndPrintCancelFoodWorkJobs4(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextCancelFoodWorkPrintJobs&printer=4&fl=" + fl + "&instance=" + config.instance;
        ReceiptWorker.fetchAndPrintCancelWorkJobs(config, "Storno Speise", url, asyncUsb, allowBigPackets);
    }

    public static void fetchAndPrintCancelDrinkWorkJobs1(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextCancelDrinkWorkPrintJobs&printer=1&fl=" + fl + "&instance=" + config.instance;
        ReceiptWorker.fetchAndPrintCancelWorkJobs(config, "Storno Getr\u00e4nk", url, asyncUsb, allowBigPackets);
    }

    public static void fetchAndPrintCancelDrinkWorkJobs2(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextCancelDrinkWorkPrintJobs&printer=2&fl=" + fl + "&instance=" + config.instance;
        ReceiptWorker.fetchAndPrintCancelWorkJobs(config, "Storno Getr\u00e4nk", url, asyncUsb, allowBigPackets);
    }

    public static void fetchAndPrintCancelDrinkWorkJobs3(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextCancelDrinkWorkPrintJobs&printer=3&fl=" + fl + "&instance=" + config.instance;
        ReceiptWorker.fetchAndPrintCancelWorkJobs(config, "Storno Getr\u00e4nk", url, asyncUsb, allowBigPackets);
    }

    public static void fetchAndPrintCancelDrinkWorkJobs4(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextCancelDrinkWorkPrintJobs&printer=4&fl=" + fl + "&instance=" + config.instance;
        ReceiptWorker.fetchAndPrintCancelWorkJobs(config, "Storno Getr\u00e4nk", url, asyncUsb, allowBigPackets);
    }

    public static void fetchAndPrintCancelWorkJobs(Config config, String headline, String url, boolean asyncUsb, boolean allowBigPackets) {
        String jobs = WebReader.readUrl(url, config.baseusername, config.basepass, config.printcode, null);
        if (jobs == null) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        ReceiptUsbDevice receiptUsbDevice = new ReceiptUsbDevice();
        try {
            List jobReceipts = (List)mapper.readValue(jobs, (TypeReference)new TypeReference<List<CancelWorkJob>>(){});
            for (CancelWorkJob job : jobReceipts) {
                ReceiptWorker.printCancelWorkReceipt(config, receiptUsbDevice, job, headline, asyncUsb, allowBigPackets);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void fetchAndPrintClosingJobs(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextClosingPrintJobs&language=0&fl=" + fl + "&instance=" + config.instance;
        String jobs = WebReader.readUrl(url, config.baseusername, config.basepass, config.printcode, null);
        if (jobs == null) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        ReceiptUsbDevice receiptUsbDevice = new ReceiptUsbDevice();
        try {
            List closings = (List)mapper.readValue(jobs, (TypeReference)new TypeReference<List<Closing>>(){});
            for (Closing closing : closings) {
                ReceiptWorker.printClosing(config, receiptUsbDevice, closing, asyncUsb, allowBigPackets);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void fetchAndPrintReceiptJobs(Config config, boolean asyncUsb, boolean allowBigPackets, int fl) {
        ReceiptUsbDevice receiptUsbDevice = new ReceiptUsbDevice();
        String url = String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getNextReceiptPrintJobs&language=0" + "&fl=" + fl + "&printers=1,2,3,4,5,6&instance=" + config.instance;
        String jobs = WebReader.readUrl(url, config.baseusername, config.basepass, config.printcode, null);
        if (jobs == null) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            List receipts = (List)mapper.readValue(jobs, (TypeReference)new TypeReference<List<ReceiptJob>>(){});
            for (ReceiptJob receipt : receipts) {
                ReceiptWorker.printReceipt(config, receiptUsbDevice, receipt, asyncUsb, allowBigPackets);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void printReceipt(Config config, ReceiptUsbDevice receiptUsbDevice, ReceiptJob aReceiptJob, boolean asyncUsb, boolean allowBigPackets) {
        byte[] receipt;
        Bill aBill = aReceiptJob.bill;
        String receiptId = aReceiptJob.id;
        System.out.println("Print Receipt Job: " + receiptId);
        int printersize = config.printersize;
        byte[] logobytesForPrinter = config.logo;
        if (logobytesForPrinter == null) {
            logobytesForPrinter = new byte[]{};
        }
        EscPos escpos = new EscPos();
        if (aReceiptJob.template.trim().compareTo("") == 0) {
            receipt = escpos.createReceipt(config, logobytesForPrinter, aBill);
        } else {
            CustomReceipt customReceipt = new CustomReceipt(printersize, aReceiptJob.template, aReceiptJob.hosttext);
            receipt = customReceipt.createReceipt(config, logobytesForPrinter, aBill);
        }
        try {
            if (ReceiptUsbDevice.printDevice(config, receipt, asyncUsb, allowBigPackets)) {
                ReceiptWorker.deleteJob(config, Integer.parseInt(receiptId));
            }
        }
        catch (UsbDisconnectedException | UsbException | UsbNotActiveException e) {
            e.printStackTrace();
        }
    }

    private static void printClosing(Config config, ReceiptUsbDevice receiptUsbDevice, Closing aClosingJob, boolean asyncUsb, boolean allowBigPackets) {
        int jobId = aClosingJob.id;
        System.out.println("Print Closing Job: " + jobId);
        EscPos escpos = new EscPos();
        byte[] closingbytes = escpos.createClosing(config, aClosingJob);
        try {
            if (ReceiptUsbDevice.printDevice(config, closingbytes, asyncUsb, allowBigPackets)) {
                ReceiptWorker.deleteJob(config, jobId);
            }
        }
        catch (UsbDisconnectedException | UsbException | UsbNotActiveException e) {
            e.printStackTrace();
        }
    }

    private static void printCancelWorkReceipt(Config config, ReceiptUsbDevice receiptUsbDevice, CancelWorkJob aJob, String headline, boolean asyncUsb, boolean allowBigPackets) {
        EscPos escpos = new EscPos();
        byte[] receipt = new byte[]{};
        if (aJob.template.trim().compareTo("") == 0) {
            receipt = escpos.createCancelWorkReceipt(config, aJob, headline);
        } else {
            int printersize = config.printersize;
            CustomReceipt customReceipt = new CustomReceipt(printersize, aJob.template, null);
            receipt = customReceipt.createReceipt(config, null, aJob);
        }
        System.out.println("Print Cancel Work Job: " + aJob.id);
        try {
            if (ReceiptUsbDevice.printDevice(config, receipt, asyncUsb, allowBigPackets)) {
                ReceiptWorker.deleteJob(config, Integer.parseInt(aJob.id));
            }
        }
        catch (UsbDisconnectedException | UsbException | UsbNotActiveException e) {
            e.printStackTrace();
        }
    }

    private static void printWorkReceipt(Config config, ReceiptUsbDevice receiptUsbDevice, WorkJob aJob, String headline, boolean asyncUsb, boolean allowBigPackets) {
        EscPos escpos = new EscPos();
        byte[] receipt = new byte[]{};
        if (aJob.template.trim().compareTo("") == 0) {
            receipt = escpos.createWorkReceipt(config, aJob, headline);
        } else {
            int printersize = config.printersize;
            CustomReceipt customReceipt = new CustomReceipt(printersize, aJob.template, null);
            receipt = customReceipt.createReceipt(config, null, aJob);
        }
        System.out.println("Print Work Job: " + aJob.id);
        try {
            if (ReceiptUsbDevice.printDevice(config, receipt, asyncUsb, allowBigPackets)) {
                ReceiptWorker.deleteJob(config, Integer.parseInt(aJob.id));
            }
        }
        catch (UsbDisconnectedException | UsbException | UsbNotActiveException e) {
            e.printStackTrace();
        }
    }

    private static void deleteJob(Config config, int id) {
        WebReader.readUrl(String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=deletePrintJob", config.baseusername, config.basepass, config.printcode, Integer.toString(id));
    }
}

