/*
 * Decompiled with CFR 0.152.
 */
package javaprinter;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javaprinter.ConfigReader;
import javaprinter.DumpDevices;
import javaprinter.ReceiptWorker;
import javaprinter.json.Config;
import javaprinter.logo.LogoPrinter;
import javax.imageio.ImageIO;
import javax.usb.UsbException;
import org.apache.commons.codec.binary.Base64;

public class Main {
    private static int fl = 14;

    public static void main(String[] args) {
        String configFile;
        boolean asyncUsb = false;
        boolean allowBigPackets = false;
        if (args.length < 1) {
            System.err.println("Syntax: java -jar javaprinter.jar config.json");
            return;
        }
        if (args.length == 2) {
            if (args[1].compareToIgnoreCase("async") == 0) {
                asyncUsb = true;
                System.out.println("Use asynchr USB piping!");
            } else if (args[1].compareToIgnoreCase("big") == 0) {
                allowBigPackets = true;
                System.out.println("Allow big USB packets.");
            }
        }
        if ((configFile = args[0]).compareToIgnoreCase("dump") == 0) {
            DumpDevices dumpDevices = new DumpDevices();
            try {
                DumpDevices.dump();
            }
            catch (UsbException e) {
                e.printStackTrace();
            }
        } else {
            boolean configRead = false;
            Config config = null;
            while (!configRead) {
                config = new ConfigReader().getConfig(configFile, fl);
                if (config == null) {
                    System.err.println("Cannot access config from webserver - wait for some time and retry");
                    try {
                        System.err.println("Cannot access webserver - wait for some time and retry");
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                System.out.println("Config: " + config);
                URL url = null;
                try {
                    url = new URL(String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getLogoAsPng");
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    try {
                        System.err.println("Cannot access webserver - wait for some time and retry");
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                try {
                    URLConnection uc = url.openConnection();
                    uc.setRequestProperty("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])(String.valueOf(config.baseusername) + ":" + config.basepass).getBytes())));
                    BufferedImage img = ImageIO.read(uc.getInputStream());
                    LogoPrinter lp = new LogoPrinter();
                    if (img != null) {
                        config.insertLogoBytes(lp.getImageAsBytes(img, config.logoscale, config.printersize));
                    }
                }
                catch (IOException e) {
                    try {
                        System.err.println(" Cannot set logo into config, maybe web server not accessible - wait for some time and retry");
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                configRead = true;
            }
            int counterpollbills = 0;
            int counterpollworksf = 0;
            int counterpollworksd = 0;
            int counterpollclosings = 0;
            int counterpollpickups = 0;
            while (true) {
                try {
                    if (counterpollbills == 0) {
                        ReceiptWorker.fetchAndPrintReceiptJobs(config, asyncUsb, allowBigPackets, fl);
                        counterpollbills = config.pollbills;
                    } else {
                        --counterpollbills;
                    }
                    if (counterpollclosings == 0) {
                        ReceiptWorker.fetchAndPrintClosingJobs(config, asyncUsb, allowBigPackets, fl);
                        counterpollclosings = config.pollclosings;
                    } else {
                        --counterpollclosings;
                    }
                    if (counterpollpickups == 0) {
                        ReceiptWorker.fetchAndPrintPickupJobs(config, asyncUsb, allowBigPackets, fl);
                        counterpollpickups = config.pollpickups;
                    } else {
                        --counterpollpickups;
                    }
                    if (counterpollworksf == 0) {
                        ReceiptWorker.fetchAndPrintFoodWorkJobs1(config, asyncUsb, allowBigPackets, fl);
                        ReceiptWorker.fetchAndPrintFoodWorkJobs2(config, asyncUsb, allowBigPackets, fl);
                        ReceiptWorker.fetchAndPrintFoodWorkJobs3(config, asyncUsb, allowBigPackets, fl);
                        ReceiptWorker.fetchAndPrintFoodWorkJobs4(config, asyncUsb, allowBigPackets, fl);
                        ReceiptWorker.fetchAndPrintCancelFoodWorkJobs1(config, asyncUsb, allowBigPackets, fl);
                        ReceiptWorker.fetchAndPrintCancelFoodWorkJobs2(config, asyncUsb, allowBigPackets, fl);
                        ReceiptWorker.fetchAndPrintCancelFoodWorkJobs3(config, asyncUsb, allowBigPackets, fl);
                        ReceiptWorker.fetchAndPrintCancelFoodWorkJobs4(config, asyncUsb, allowBigPackets, fl);
                        counterpollworksf = config.pollworksf;
                    } else {
                        --counterpollworksf;
                    }
                    if (counterpollworksd == 0) {
                        ReceiptWorker.fetchAndPrintDrinkWorkJobs1(config, asyncUsb, allowBigPackets, fl);
                        ReceiptWorker.fetchAndPrintDrinkWorkJobs2(config, asyncUsb, allowBigPackets, fl);
                        ReceiptWorker.fetchAndPrintDrinkWorkJobs3(config, asyncUsb, allowBigPackets, fl);
                        ReceiptWorker.fetchAndPrintDrinkWorkJobs4(config, asyncUsb, allowBigPackets, fl);
                        ReceiptWorker.fetchAndPrintCancelDrinkWorkJobs1(config, asyncUsb, allowBigPackets, fl);
                        ReceiptWorker.fetchAndPrintCancelDrinkWorkJobs2(config, asyncUsb, allowBigPackets, fl);
                        ReceiptWorker.fetchAndPrintCancelDrinkWorkJobs3(config, asyncUsb, allowBigPackets, fl);
                        ReceiptWorker.fetchAndPrintCancelDrinkWorkJobs4(config, asyncUsb, allowBigPackets, fl);
                        counterpollworksd = config.pollworksd;
                    } else {
                        --counterpollworksd;
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception in main loop catched");
                    e.printStackTrace();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }
}

