/*
 * Decompiled with CFR 0.152.
 */
package javaprinter;

import java.util.Calendar;
import java.util.List;
import javaprinter.genutils.GenUtils;
import javaprinter.json.Config;
import javaprinter.json.closing.Closing;
import javaprinter.json.closing.ClosingDetails;
import javaprinter.json.closing.ClosingOverview;
import javaprinter.json.closing.ClosingPayment;
import javaprinter.json.closing.ClosingSummary;
import javaprinter.json.closing.ClosingTaxesSum;
import javaprinter.json.receipt.Bill;
import javaprinter.json.receipt.Product;
import javaprinter.json.receipt.Taxes;
import javaprinter.json.work.CancelWorkJob;
import javaprinter.json.work.WorkJob;
import javaprinter.json.work.WorkProduct;

public class EscPos {
    byte[] space_byte = new byte[]{32};
    byte[] dsizeon = new byte[]{27, 33, 16};
    byte[] dsizedouble = new byte[]{27, 33, 48};
    byte[] dsizeoff;
    byte[] emphasized;
    byte[] indent;

    public EscPos() {
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 33;
        this.dsizeoff = byArray;
        this.emphasized = new byte[]{27, 33, 8};
        this.indent = new byte[]{32, 32, 32};
    }

    private byte[] createReceiptHeader(String waiterTxt, String waiter, String tableTxt, String table, String idTxt, String id, String billday, String billmonth, String billyear, String billhour, String billmin, String guestinfo, int length, int language) {
        int half1 = length / 2;
        int half2 = length - half1;
        String tablepart = GenUtils.PadRight("Zum Mitnehmen", half1);
        if (language == 1) {
            tablepart = GenUtils.PadRight("Take away", half1);
        } else if (language == 2) {
            tablepart = GenUtils.PadRight("Para llevar", half1);
        }
        if (table.compareTo("-") != 0) {
            table = GenUtils.cutText(table, 8);
            tablepart = GenUtils.PadRight(String.valueOf(tableTxt) + table, half1);
        }
        byte[] receiptbytes = GenUtils.str2bytes(tablepart);
        String idpart = GenUtils.PadLeft(String.valueOf(idTxt) + id, half2);
        byte[] idpartbytes = GenUtils.str2bytes(idpart);
        receiptbytes = GenUtils.MergeArrays(receiptbytes, idpartbytes, GenUtils.lf_byte);
        Calendar dt = GenUtils.getCal(billyear, billmonth, billday, billhour, billmin);
        String thedatetime = GenUtils.calToStr(dt);
        byte[] dateline = GenUtils.str2bytes(GenUtils.PadLeft(thedatetime, length));
        receiptbytes = GenUtils.MergeArrays(receiptbytes, dateline, GenUtils.lf_byte, GenUtils.lf_byte);
        byte[] userline = GenUtils.str2bytes(GenUtils.PadRight(String.valueOf(waiterTxt) + " " + waiter, length));
        receiptbytes = GenUtils.MergeArrays(receiptbytes, userline, GenUtils.lf_byte, GenUtils.lf_byte);
        if (guestinfo.compareTo("") != 0) {
            byte[] guestInfoBytes = GenUtils.str2bytes(guestinfo);
            receiptbytes = GenUtils.MergeArrays(receiptbytes, guestInfoBytes, GenUtils.lf_byte, GenUtils.lf_byte, GenUtils.lf_byte);
        }
        return receiptbytes;
    }

    private byte[] createProdLine(String no, String descr, String pricelevel, String price, String total, int length) {
        String pricelevelTxt = "";
        int spaceForPriceLevel = 0;
        if (pricelevel != null && pricelevel.compareToIgnoreCase("a") != 0) {
            pricelevelTxt = " (" + pricelevel + ")";
            spaceForPriceLevel = pricelevelTxt.length();
        }
        int charsForDescr = length - 3 - 6 - 6 - 3 - spaceForPriceLevel;
        descr = GenUtils.cutText(descr, charsForDescr);
        descr = String.valueOf(descr) + pricelevelTxt;
        int maxSpaceAllowed = length - 3 - 6 - 6 - 3;
        byte[] nobytes = new byte[]{};
        byte[] pricebytes = new byte[]{};
        byte[] totalbytes = new byte[]{};
        if (no.compareToIgnoreCase("0") != 0) {
            nobytes = GenUtils.str2bytes(GenUtils.PadLeft(no, 3));
            pricebytes = GenUtils.str2bytes(GenUtils.PadLeft(price, 6));
            totalbytes = GenUtils.str2bytes(GenUtils.PadLeft(total, 6));
        }
        byte[] descrbytes = GenUtils.str2bytes(GenUtils.PadRight(descr, maxSpaceAllowed));
        return GenUtils.MergeArrays(nobytes, this.space_byte, descrbytes, this.space_byte, pricebytes, this.space_byte, totalbytes, GenUtils.lf_byte);
    }

    private byte[] createMwstLine(String mwst1, String mwst2, String netto, String brutto) {
        byte[] mwst1bytes = GenUtils.str2bytes(GenUtils.PadLeft(mwst1, 6));
        byte[] mwst2bytes = GenUtils.str2bytes(GenUtils.PadLeft(mwst2, 5));
        byte[] nettobytes = GenUtils.str2bytes(GenUtils.PadLeft(netto, 7));
        byte[] bruttobytes = GenUtils.str2bytes(GenUtils.PadLeft(brutto, 7));
        return GenUtils.MergeArrays(mwst1bytes, this.space_byte, mwst2bytes, this.space_byte, nettobytes, this.space_byte, bruttobytes, GenUtils.lf_byte);
    }

    private byte[] createSumeLine(String sum, String sumTxt, String currencyTxt, int length) {
        currencyTxt.trim();
        String sumstr = GenUtils.PadLeft(String.valueOf(sumTxt) + " " + sum + " " + currencyTxt.trim(), length);
        byte[] receiptbytes = GenUtils.str2bytes(sumstr);
        return GenUtils.MergeArrays(this.dsizeon, receiptbytes, this.dsizeoff, GenUtils.lf_byte);
    }

    private byte[] createClosingInfo(int id, int billcount, String billsum, String remark, String closingDate, String currency) {
        byte[] header = GenUtils.MergeArrays(this.dsizeon, GenUtils.str2bytes("Tageslosung Nr. " + id), this.dsizeoff, GenUtils.lf_byte, GenUtils.lf_byte);
        byte[] datebytes = GenUtils.MergeArrays(GenUtils.str2bytes("Datum:     " + closingDate), GenUtils.lf_byte);
        byte[] billcountbytes = GenUtils.MergeArrays(GenUtils.str2bytes("Bons:      " + billcount), GenUtils.lf_byte);
        byte[] billsumbytes = GenUtils.MergeArrays(GenUtils.str2bytes("Summe:     "), this.dsizeon, GenUtils.str2bytes(billsum), this.dsizeoff, GenUtils.str2bytes(" " + currency), GenUtils.lf_byte);
        if (remark != null && remark != "") {
            byte[] rem = GenUtils.str2bytes("Bemerkung: " + remark);
            billsumbytes = GenUtils.MergeArrays(billsumbytes, rem, GenUtils.lf_byte);
        }
        byte[] all = GenUtils.MergeArrays(header, datebytes, billcountbytes, billsumbytes);
        return all;
    }

    private byte[] createClosingTitle(String companyInfo) {
        byte[] titlebytes = GenUtils.MergeArrays(GenUtils.str2bytes(companyInfo), GenUtils.lf_byte, GenUtils.lf_byte);
        return titlebytes;
    }

    private byte[] createClosingOverview(List<ClosingOverview> overview, String decpoint, int length) {
        byte[] header = GenUtils.MergeArrays(GenUtils.lf_byte, GenUtils.str2bytes("Vorgang:"), GenUtils.lf_byte);
        header = GenUtils.MergeArrays(header, GenUtils.str2bytes("  EINL: Bareinlage/-auslage"), GenUtils.lf_byte);
        header = GenUtils.MergeArrays(header, GenUtils.str2bytes("  STOR: Bonstorno"), GenUtils.lf_byte);
        header = GenUtils.MergeArrays(header, GenUtils.str2bytes("  VERK: Abrechnung"), GenUtils.lf_byte);
        header = GenUtils.MergeArrays(header, GenUtils.str2bytes("  "), GenUtils.lf_byte);
        header = GenUtils.MergeArrays(header, GenUtils.str2bytes("   Summe  Netto Vorg. Zahl.weg"), GenUtils.lf_byte);
        header = GenUtils.MergeArrays(header, GenUtils.str2bytes("-----------------------------"), GenUtils.lf_byte);
        String cancelledUnpaidBrutto = " 0,00";
        String cancelledUnpaidNetto = " 0,00";
        for (ClosingOverview anOverview : overview) {
            String aSum = GenUtils.PadLeft(anOverview.sum.replace(".", decpoint), 8);
            String name = GenUtils.cutText(anOverview.name, length - 22);
            String status = anOverview.status;
            String tax = GenUtils.PadLeft(anOverview.netto.replace(".", decpoint), 6);
            if (status == null) {
                status = "VERK ";
            } else if (status.compareToIgnoreCase("c") == 0) {
                status = "EINL ";
                name = "Bar";
            } else if (status.compareToIgnoreCase("s") == 0 || status.compareToIgnoreCase("x") == 0) {
                status = "STOR ";
                name = "";
            } else if (status.compareToIgnoreCase("d") == 0) {
                cancelledUnpaidBrutto = aSum;
                cancelledUnpaidNetto = GenUtils.PadLeft(anOverview.netto.replace(".", decpoint), 8);
                continue;
            }
            header = GenUtils.MergeArrays(header, GenUtils.str2bytes(aSum), this.space_byte, GenUtils.str2bytes(tax), this.space_byte, GenUtils.str2bytes(status), this.space_byte, GenUtils.str2bytes(name), GenUtils.lf_byte);
        }
        header = GenUtils.MergeArrays(header, GenUtils.lf_byte);
        header = GenUtils.MergeArrays(header, GenUtils.str2bytes("Storno vor Abrechnung:"), GenUtils.lf_byte);
        header = GenUtils.MergeArrays(header, GenUtils.str2bytes(" Brutto:" + cancelledUnpaidBrutto), GenUtils.lf_byte);
        header = GenUtils.MergeArrays(header, GenUtils.str2bytes(" Netto: " + cancelledUnpaidNetto), GenUtils.lf_byte);
        header = GenUtils.MergeArrays(header, GenUtils.lf_byte);
        return header;
    }

    private byte[] createClosingTaxesSum(String name, List<ClosingTaxesSum> taxessums, String decpoint, int length) {
        byte[] header = GenUtils.MergeArrays(GenUtils.str2bytes(String.valueOf(name) + ":"), GenUtils.lf_byte, GenUtils.str2bytes("Steuersatz  Brutto   Netto"), GenUtils.lf_byte);
        for (ClosingTaxesSum taxessum : taxessums) {
            String tax = GenUtils.PadLeft(taxessum.t.replace(".", decpoint), 10);
            String brutto = GenUtils.PadLeft(taxessum.bruttosum.replace(".", decpoint), 6);
            String netto = GenUtils.PadLeft(taxessum.nettosum.replace(".", decpoint), 5);
            header = GenUtils.MergeArrays(header, GenUtils.str2bytes(tax), this.space_byte, this.space_byte, GenUtils.str2bytes(brutto), this.space_byte, this.space_byte, this.space_byte, GenUtils.str2bytes(netto), GenUtils.lf_byte);
        }
        header = GenUtils.MergeArrays(header, GenUtils.lf_byte);
        return header;
    }

    private byte[] createClosingDetails(List<ClosingDetails> details, String decpoint, int length) {
        int prodTextLength = length - 3 - 7 - 5 - 8 - 4;
        String prodlegend = GenUtils.cutText("Produkt", prodTextLength);
        prodlegend = GenUtils.PadRight(prodlegend, prodTextLength);
        byte[] det = GenUtils.str2bytes("Anz " + prodlegend + "   Preis     %  G.preis");
        det = GenUtils.MergeArrays(det, GenUtils.lf_byte);
        for (ClosingDetails aDetail : details) {
            String count = String.valueOf(GenUtils.PadLeft(Integer.toString(aDetail.count), 3)) + ' ';
            String prod = GenUtils.cutText(aDetail.productname, prodTextLength);
            prod = GenUtils.PadRight(prod, prodTextLength);
            String price = GenUtils.PadLeft(GenUtils.formatPrice(aDetail.price, decpoint), 7);
            String tax = GenUtils.PadLeft(aDetail.tax.replace(".", decpoint), 5);
            String sumprice = GenUtils.PadLeft(GenUtils.formatPrice(aDetail.sumprice, decpoint), 8);
            det = GenUtils.MergeArrays(det, GenUtils.str2bytes(count), GenUtils.str2bytes(prod), this.space_byte, GenUtils.str2bytes(price), this.space_byte, GenUtils.str2bytes(tax), this.space_byte, GenUtils.str2bytes(sumprice), GenUtils.lf_byte);
        }
        return det;
    }

    public byte[] createClosing(Config config, Closing closing) {
        String decpoint = config.decpoint;
        String currency = config.currency;
        ClosingSummary closingSummary = closing.closing;
        String companyInfo = closingSummary.companyinfo;
        int closid = closingSummary.closing.id;
        int billcount = closingSummary.closing.billcount;
        String billsum = GenUtils.formatPrice(closingSummary.closing.billsum, decpoint);
        String remark = closingSummary.closing.remark;
        String closingDate = closingSummary.closing.closingdate;
        byte[] closingTitleBytes = new byte[]{};
        if (closingSummary.closshowci == 1) {
            closingTitleBytes = this.createClosingTitle(companyInfo);
        }
        byte[] closingHeaderBytes = this.createClosingInfo(closid, billcount, billsum, remark, closingDate, currency);
        byte[] closingOverview = this.createClosingOverview(closingSummary.overview, decpoint, config.printersize);
        byte[] closingTaxesSum = this.createClosingTaxesSum("Total", closingSummary.taxessum, decpoint, config.printersize);
        byte[] closingPayments = new byte[]{};
        if (closingSummary.closshowpaytaxes == 1) {
            closingPayments = GenUtils.MergeArrays(new byte[][]{GenUtils.lf_byte});
            for (ClosingPayment closingPayment : closingSummary.paymenttaxessum) {
                String paymentTxt = closingPayment.payment;
                byte[] closingPaymentTaxes = this.createClosingTaxesSum(paymentTxt, closingPayment.paymenttaxessum, decpoint, config.printersize);
                closingPayments = GenUtils.MergeArrays(closingPayments, closingPaymentTaxes);
            }
            closingPayments = GenUtils.MergeArrays(closingPayments, GenUtils.lf_byte);
        }
        byte[] closingDetails = new byte[]{};
        if (closingSummary.closshowprods == 1) {
            closingDetails = this.createClosingDetails(closingSummary.details, decpoint, config.printersize);
        }
        return GenUtils.MergeArrays(GenUtils.int2byteArray(config.escinits), closingTitleBytes, closingHeaderBytes, closingOverview, closingTaxesSum, closingPayments, closingDetails, GenUtils.lf_byte, GenUtils.lf_byte, GenUtils.lf_byte, GenUtils.lf_byte, GenUtils.int2byteArray(config.escposts));
    }

    public byte[] createReceipt(Config config, byte[] logobytes, Bill bill) {
        String decpoint = config.decpoint;
        String note = config.companyinfo;
        int billlanguage = 0;
        Product[] allProducts = bill.products;
        byte[] header = this.createReceiptHeader(bill.translations.waiter, bill.billoverallinfo.username, bill.translations.table, bill.billoverallinfo.table, bill.translations.id, bill.billoverallinfo.id, bill.billoverallinfo.billday, bill.billoverallinfo.billmonth, bill.billoverallinfo.billyear, bill.billoverallinfo.billhour, bill.billoverallinfo.billmin, bill.billoverallinfo.guestinfo, config.printersize, billlanguage);
        byte[] prodLegend = this.createProdLine(GenUtils.cutText(bill.translations.no, 3), bill.translations.descr, null, GenUtils.cutText(bill.translations.brutto, 6), GenUtils.cutText(bill.translations.total, 6), config.printersize);
        byte[] prodBytes = new byte[]{};
        Product[] productArray = allProducts;
        int n = allProducts.length;
        int n2 = 0;
        while (n2 < n) {
            Product product = productArray[n2];
            String total = String.format("%.2f", (double)product.count * product.price).replace(".", decpoint);
            String price = String.format("%.2f", product.price).replace(".", decpoint);
            byte[] aProdLine = this.createProdLine(Integer.toString(product.count), product.productname, product.pricelevel, price, total, config.printersize);
            prodBytes = GenUtils.MergeArrays(prodBytes, aProdLine);
            ++n2;
        }
        String brutto = String.format("%.2f", bill.billoverallinfo.brutto).replace(".", decpoint);
        byte[] legend = this.createMwstLine(String.valueOf(bill.translations.mwst) + "%", bill.translations.mwst, bill.translations.netto, bill.translations.brutto);
        Taxes[] taxes = bill.taxes;
        byte[] taxvalues = new byte[]{};
        Taxes[] taxesArray = taxes;
        int aProdLine = taxes.length;
        int price = 0;
        while (price < aProdLine) {
            Taxes tax = taxesArray[price];
            String taxtax = String.format("%.2f", tax.tax).replace(".", decpoint);
            String taxmwst = String.format("%.2f", tax.mwst).replace(".", decpoint);
            String taxnetto = String.format("%.2f", tax.netto).replace(".", decpoint);
            String taxbrutto = String.format("%.2f", tax.brutto).replace(".", decpoint);
            taxvalues = GenUtils.MergeArrays(taxvalues, this.createMwstLine(taxtax, taxmwst, taxnetto, taxbrutto));
            ++price;
        }
        byte[] sumline = this.createSumeLine(brutto, bill.translations.sum, config.currency, config.printersize);
        byte[] notebytes = GenUtils.createNote(note, config.printersize, true);
        byte[] hostbytes = new byte[]{};
        int host = Integer.parseInt(bill.billoverallinfo.host);
        if (host == 1) {
            hostbytes = GenUtils.createHostPart(config.printersize);
        }
        if (logobytes == null) {
            logobytes = new byte[]{};
        }
        byte[] completeReceipt = GenUtils.MergeArrays(GenUtils.int2byteArray(config.escinits), logobytes, GenUtils.lf_byte, header, prodLegend, prodBytes, GenUtils.lf_byte, legend, taxvalues, GenUtils.lf_byte, sumline, GenUtils.lf_byte, notebytes, GenUtils.lf_byte, hostbytes, GenUtils.lf_byte, GenUtils.lf_byte, GenUtils.int2byteArray(config.escposts), GenUtils.lf_byte, GenUtils.lf_byte, GenUtils.lf_byte);
        return completeReceipt;
    }

    public byte[] createWorkReceipt(Config config, WorkJob workJob, String headline) {
        byte[] headbytes = GenUtils.str2bytes(headline);
        byte[] tableInfo = GenUtils.MergeArrays(this.dsizeon, GenUtils.str2bytes(workJob.content.table), this.dsizeoff, GenUtils.str2bytes(" - " + workJob.content.time));
        byte[] headerbytes = GenUtils.MergeArrays(this.dsizedouble, headbytes, this.dsizeoff, GenUtils.lf_byte, tableInfo, GenUtils.lf_byte, GenUtils.lf_byte);
        byte[] prodBytes = new byte[]{};
        WorkProduct[] workProductArray = workJob.content.products;
        int n = workJob.content.products.length;
        int n2 = 0;
        while (n2 < n) {
            WorkProduct product = workProductArray[n2];
            byte[] aProdBytes = GenUtils.MergeArrays(this.emphasized, GenUtils.str2bytes(product.longname), this.dsizeoff, GenUtils.lf_byte);
            if (workJob.bigfontworkreceipt == 1) {
                aProdBytes = GenUtils.MergeArrays(this.dsizedouble, GenUtils.str2bytes(product.longname), this.dsizeoff, GenUtils.lf_byte);
            }
            if (product.option != null && product.option != "") {
                byte[] optionbytes = GenUtils.str2bytes("(" + product.option + ")");
                aProdBytes = workJob.bigfontworkreceipt == 0 ? GenUtils.MergeArrays(aProdBytes, this.indent, optionbytes, GenUtils.lf_byte) : GenUtils.MergeArrays(aProdBytes, this.indent, this.dsizeon, optionbytes, this.dsizeoff, GenUtils.lf_byte);
            }
            if (product.extras != null && product.extras.length > 0) {
                String[] stringArray = product.extras;
                int n3 = product.extras.length;
                int n4 = 0;
                while (n4 < n3) {
                    String anExtra = stringArray[n4];
                    byte[] extrabytes = GenUtils.str2bytes("+ " + anExtra);
                    aProdBytes = workJob.bigfontworkreceipt == 0 ? GenUtils.MergeArrays(aProdBytes, this.indent, extrabytes, GenUtils.lf_byte) : GenUtils.MergeArrays(aProdBytes, this.indent, this.dsizeon, extrabytes, this.dsizeoff, GenUtils.lf_byte);
                    ++n4;
                }
            }
            if (config.smallformat != 1) {
                aProdBytes = GenUtils.MergeArrays(aProdBytes, GenUtils.lf_byte);
            }
            prodBytes = GenUtils.MergeArrays(prodBytes, aProdBytes);
            ++n2;
        }
        if (config.smallformat != 1) {
            return GenUtils.MergeArrays(GenUtils.int2byteArray(config.escinits), headerbytes, prodBytes, GenUtils.lf_byte, GenUtils.lf_byte, GenUtils.lf_byte, GenUtils.lf_byte, GenUtils.int2byteArray(config.escposts));
        }
        return GenUtils.MergeArrays(GenUtils.int2byteArray(config.escinits), headerbytes, prodBytes, GenUtils.lf_byte, GenUtils.lf_byte, GenUtils.int2byteArray(config.escposts));
    }

    public byte[] createCancelWorkReceipt(Config config, CancelWorkJob workJob, String headline) {
        byte[] header = GenUtils.str2bytes("Stornierung");
        byte[] what = GenUtils.str2bytes("Zu stornieren: " + workJob.longname);
        byte[] extras = GenUtils.str2bytes("  Extras: " + workJob.extras);
        String decpoint = config.decpoint;
        String priceStr = workJob.price.replace(".", decpoint);
        byte[] price = GenUtils.str2bytes("  Preis: " + priceStr);
        byte[] table = GenUtils.str2bytes("  Tisch: " + workJob.table);
        byte[] origReceipt = GenUtils.str2bytes("  Von Arbeitsbon: " + workJob.refworkid);
        byte[] complete = GenUtils.MergeArrays(GenUtils.int2byteArray(config.escinits), this.dsizedouble, header, this.dsizeoff, GenUtils.lf_byte, GenUtils.lf_byte, what, GenUtils.lf_byte, extras, GenUtils.lf_byte, price, GenUtils.lf_byte, table, GenUtils.lf_byte, origReceipt, GenUtils.lf_byte, GenUtils.lf_byte, GenUtils.int2byteArray(config.escposts));
        return complete;
    }
}

